import asyncio
import logging
import uuid

from sendr_qlog import LoggerContext

from {{cookiecutter.import_path}}.conf import settings
from {{cookiecutter.import_path}}.core.actions.base import BaseAction
from {{cookiecutter.import_path}}.interactions import InteractionClients
from {{cookiecutter.import_path}}.interactions.base import BaseInteractionClient, create_connector
from {{cookiecutter.import_path}}.storage import Storage
from {{cookiecutter.import_path}}.utils.db import create_configured_engine


def create_shell_context():
    loop = asyncio.get_event_loop()

    BaseInteractionClient.CONNECTOR = create_connector()
    request_id = 'manual_' + uuid.uuid4().hex
    logger = LoggerContext(logging.getLogger(), {'request_id': request_id})
    clients = InteractionClients(logger, request_id)

    db_engine = create_configured_engine()

    conn = loop.run_until_complete(db_engine.acquire().__aenter__())
    storage = Storage(conn)

    BaseAction.context.logger = logger
    BaseAction.context.request_id = request_id
    BaseAction.context.db_engine = db_engine

    return {
        'clients': clients,
        'db_engine': db_engine,
        'logger': logger,
        'request_id': request_id,
        'settings': settings,
        'storage': storage,
    }
